<?php
if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);

/**
*
* @package VehicleManager
* @copyright 2013 by Ordasoft
* @author Andrey Kvasnevskiy - OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Homepage: https://ordasoft.com/
*
* */

class com_VehicleManagerInstallerScript{

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent){
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Save admin settings before updete
        if ( $type == 'update' ) {
            // $vehiclemanager_configuration:
            include(JPATH_ROOT . '/administrator/components/com_vehiclemanager/admin.vehiclemanager.class.conf.php');

            $GLOBALS['vehiclemanager_configuration_old'] = $vehiclemanager_configuration;
        }

        $db = JFactory::getDBO();
        $db->setQuery("DELETE FROM #__update_sites WHERE name = 'Vehiclemanager`s Update'");
        $db->query();
    }

    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent){
        // $parent is the class calling this method
    }

    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent){
        // $parent is the class calling this method
    }

    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent){
        // $parent is the class calling this method
        if(file_exists(JPATH_ROOT."/administrator/components/com_vehiclemanager/uninstall.vehiclemanager.php"))
            require_once(JPATH_ROOT."/administrator/components/com_vehiclemanager/uninstall.vehiclemanager.php");
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent){
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Marge old admin settings and new configuration after update
        global $vehiclemanager_configuration_old;

        if ( $type == 'update' ) {
            // $vehiclemanager_configuration new from update files
            require(JPATH_ROOT . '/administrator/components/com_vehiclemanager/admin.vehiclemanager.class.conf_new.php');

            $vehiclemanager_configuration = array_replace_recursive($vehiclemanager_configuration, $vehiclemanager_configuration_old);
        }

        if(file_exists(JPATH_ROOT."/administrator/components/com_vehiclemanager/install.vehiclemanager.php")){
            require_once(JPATH_ROOT."/administrator/components/com_vehiclemanager/install.vehiclemanager.php");
            com_install2();
        }
    }
}
